/**
 * 2009/05/05 17:14:37
 */
package jp.co.yahoo.api.maservice;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import jp.co.yahoo.api.maservice.bean.MAServiceBean;
import jp.co.yahoo.api.maservice.bean.MAWordBean;
import jp.co.yahoo.api.maservice.exception.ArgsErrorException;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * {`ԑf͗pNX
 * 
 * @author Owner
 */
public class MAService {

	/**  */
	private MAResult result;

	/**
	 * RXgN^B
	 * 
	 * @throws IOException
	 * @throws SAXException
	 * @throws ParserConfigurationException
	 */
	private MAService(MAServiceBean bean) throws ParserConfigurationException,
			SAXException, IOException {
		init(bean);
	}

	private void init(MAServiceBean bean) throws ParserConfigurationException,
			SAXException, IOException {
		String param = "";
		param += "appid=" + bean.getAppid();
		param += "&sentence=" + URLEncoder.encode(bean.getSentence(), "UTF-8");

		if (bean.getResults() != null && !"".equals(bean.getResults())) {
			param += "&results=" + bean.getResults();
		}

		if (bean.getResponse() != null && !"".equals(bean.getResponse())) {
			param += "&response=" + bean.getResponse();
		}

		if (bean.getFilter() != null && !"".equals(bean.getFilter())) {
			param += "&filter=" + bean.getFilter();
		}

		// URLNX̃CX^X𐶐
		URL helloURL = new URL(bean.getApiUrl());

		// ڑ܂
		URLConnection con = helloURL.openConnection();
		// o͂s悤ɐݒ肵܂
		con.setDoOutput(true);

		// o̓Xg[擾
		PrintWriter out = new PrintWriter(con.getOutputStream());
		out.print(param);
		out.close();

		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		Document doc = builder.parse(con.getInputStream());

		// [gm[h擾
		Node root = null;
		NodeList childs = doc.getChildNodes();
		for (int i = 0; i < childs.getLength(); i++) {
			Node c = childs.item(i);
			if (c.getNodeType() == Node.ELEMENT_NODE) {
				NodeList nodeList = c.getChildNodes();
				for (int j = 0; j < nodeList.getLength(); j++) {
					Node node = nodeList.item(j);
					if (node.getNodeType() == Node.ELEMENT_NODE) {
						root = node;
						break;
					}
				}
				break;
			}
		}

		MAResult result = new MAResult();

		childs = root.getChildNodes();
		for (int i = 0; i < childs.getLength(); i++) {
			Node c = childs.item(i);
			if (c.getNodeType() == Node.ELEMENT_NODE) {
				if ("total_count".equals(c.getNodeName())) {
					result.setTotalCount(Long.parseLong(c.getTextContent()));
				}
				if ("filtered_count".equals(c.getNodeName())) {
					result.setFilteredCount(Long.parseLong(c.getTextContent()));
				}

				if ("word_list".equals(c.getNodeName())) {
					NodeList wordList = c.getChildNodes();
					List<MAWordBean> beanList = new ArrayList<MAWordBean>();
					for (int j = 0; j < wordList.getLength(); j++) {
						Node word = wordList.item(j);
						if (word.getNodeType() == Node.ELEMENT_NODE) {
							MAWordBean wordBean = new MAWordBean();
							NodeList nodeList = word.getChildNodes();
							for (int x = 0; x < nodeList.getLength(); x++) {
								Node node = nodeList.item(x);
								if (node.getNodeType() == Node.ELEMENT_NODE) {
									if ("surface".equals(node.getNodeName())) {
										wordBean.setSurface(node
												.getTextContent());
									}
									if ("reading".equals(node.getNodeName())) {
										wordBean.setReading(node
												.getTextContent());
									}
									if ("pos".equals(node.getNodeName())) {
										wordBean.setPos(node.getTextContent());
									}
									if ("baseform".equals(node.getNodeName())) {
										wordBean.setBaseform(node
												.getTextContent());
									}
									if ("feature".equals(node.getNodeName())) {
										wordBean.setFeature(node
												.getTextContent());
									}
									if ("count".equals(node.getNodeName())) {
										wordBean.setCount(Long.parseLong(node
												.getTextContent()));
									}
								}
							}
							beanList.add(wordBean);

						}
					}
					result.setWordList(beanList);
				}
			}
		}

		setResult(result);

	}

	/**
	 * CX^X쐬
	 * 
	 * @param bean MAServiceBean
	 * @return MAService
	 * @throws ArgsErrorException
	 * @throws ParserConfigurationException
	 * @throws IOException
	 * @throws SAXException
	 */
	public static MAService getInstance(MAServiceBean bean)
			throws ArgsErrorException, ParserConfigurationException,
			SAXException, IOException {
		if (bean == null) {
			throw new ArgsErrorException("œnꂽBeanNULLłB");
		} else if (bean.getAppid() == null || "".equals(bean.getAppid())) {
			throw new ArgsErrorException("AvP[VIDNULL܂͋łB");
		} else if (bean.getSentence() == null || "".equals(bean.getSentence())) {
			throw new ArgsErrorException("͑ΏۂNULL܂͋łB");
		}

		MAService service = new MAService(bean);

		return service;
	}

	/**
	 * ʂ擾܂B
	 * 
	 * @return 
	 */
	public MAResult getResult() {
		return result;
	}

	/**
	 * ʂݒ肵܂B
	 * 
	 * @param result 
	 */
	public void setResult(final MAResult result) {
		this.result = result;
	}

}
