/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.api.maservice;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.yahoo.api.maservice.MAResult;
import jp.co.yahoo.api.maservice.bean.MAServiceBean;
import jp.co.yahoo.api.maservice.bean.MAWordBean;
import jp.co.yahoo.api.maservice.exception.ArgsErrorException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MAService {
    private MAResult result;

    private MAService(MAServiceBean bean) throws ParserConfigurationException, SAXException, IOException {
        this.init(bean);
    }

    private void init(MAServiceBean bean) throws ParserConfigurationException, SAXException, IOException {
        String param = "";
        param = String.valueOf(param) + "appid=" + bean.getAppid();
        param = String.valueOf(param) + "&sentence=" + URLEncoder.encode(bean.getSentence(), "UTF-8");
        if (bean.getResults() != null && !"".equals(bean.getResults())) {
            param = String.valueOf(param) + "&results=" + bean.getResults();
        }
        if (bean.getResponse() != null && !"".equals(bean.getResponse())) {
            param = String.valueOf(param) + "&response=" + bean.getResponse();
        }
        if (bean.getFilter() != null && !"".equals(bean.getFilter())) {
            param = String.valueOf(param) + "&filter=" + bean.getFilter();
        }
        URL helloURL = new URL(bean.getApiUrl());
        URLConnection con = helloURL.openConnection();
        con.setDoOutput(true);
        PrintWriter out = new PrintWriter(con.getOutputStream());
        out.print(param);
        out.close();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(con.getInputStream());
        Node root = null;
        NodeList childs = doc.getChildNodes();
        int i = 0;
        block0: while (i < childs.getLength()) {
            Node c = childs.item(i);
            if (c.getNodeType() == 1) {
                NodeList nodeList = c.getChildNodes();
                int j = 0;
                while (j < nodeList.getLength()) {
                    Node node = nodeList.item(j);
                    if (node.getNodeType() == 1) {
                        root = node;
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        MAResult result = new MAResult();
        childs = root.getChildNodes();
        int i2 = 0;
        while (i2 < childs.getLength()) {
            Node c = childs.item(i2);
            if (c.getNodeType() == 1) {
                if ("total_count".equals(c.getNodeName())) {
                    result.setTotalCount(Long.parseLong(c.getTextContent()));
                }
                if ("filtered_count".equals(c.getNodeName())) {
                    result.setFilteredCount(Long.parseLong(c.getTextContent()));
                }
                if ("word_list".equals(c.getNodeName())) {
                    NodeList wordList = c.getChildNodes();
                    ArrayList<MAWordBean> beanList = new ArrayList<MAWordBean>();
                    int j = 0;
                    while (j < wordList.getLength()) {
                        Node word = wordList.item(j);
                        if (word.getNodeType() == 1) {
                            MAWordBean wordBean = new MAWordBean();
                            NodeList nodeList = word.getChildNodes();
                            int x = 0;
                            while (x < nodeList.getLength()) {
                                Node node = nodeList.item(x);
                                if (node.getNodeType() == 1) {
                                    if ("surface".equals(node.getNodeName())) {
                                        wordBean.setSurface(node.getTextContent());
                                    }
                                    if ("reading".equals(node.getNodeName())) {
                                        wordBean.setReading(node.getTextContent());
                                    }
                                    if ("pos".equals(node.getNodeName())) {
                                        wordBean.setPos(node.getTextContent());
                                    }
                                    if ("baseform".equals(node.getNodeName())) {
                                        wordBean.setBaseform(node.getTextContent());
                                    }
                                    if ("feature".equals(node.getNodeName())) {
                                        wordBean.setFeature(node.getTextContent());
                                    }
                                    if ("count".equals(node.getNodeName())) {
                                        wordBean.setCount(Long.parseLong(node.getTextContent()));
                                    }
                                }
                                ++x;
                            }
                            beanList.add(wordBean);
                        }
                        ++j;
                    }
                    result.setWordList(beanList);
                }
            }
            ++i2;
        }
        this.setResult(result);
    }

    public static MAService getInstance(MAServiceBean bean) throws ArgsErrorException, ParserConfigurationException, SAXException, IOException {
        if (bean == null) {
            throw new ArgsErrorException("\u5f15\u6570\u3067\u6e21\u3055\u308c\u305fBean\u304cNULL\u3067\u3059\u3002");
        }
        if (bean.getAppid() == null || "".equals(bean.getAppid())) {
            throw new ArgsErrorException("\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3ID\u304cNULL\u307e\u305f\u306f\u7a7a\u3067\u3059\u3002");
        }
        if (bean.getSentence() == null || "".equals(bean.getSentence())) {
            throw new ArgsErrorException("\u89e3\u6790\u5bfe\u8c61\u304cNULL\u307e\u305f\u306f\u7a7a\u3067\u3059\u3002");
        }
        MAService service = new MAService(bean);
        return service;
    }

    public MAResult getResult() {
        return this.result;
    }

    public void setResult(MAResult result) {
        this.result = result;
    }
}

