/*
 * Decompiled with CFR 0.152.
 */
package jp.komono.mangaviewer.image.loader.impl;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import jp.komono.mangaviewer.image.ImageFile;
import jp.komono.mangaviewer.image.loader.ImageLoadCallback;
import jp.komono.mangaviewer.image.loader.ImageLoader;
import jp.komono.mangaviewer.image.loader.ImageLoaderReadCallback;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.ISevenZipInArchive;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;

public class SevenZipImageLoader
implements ImageLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupport(File file) {
        if (file.isFile()) {
            RandomAccessFile randomAccessFile = null;
            ISevenZipInArchive iSevenZipInArchive = null;
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                iSevenZipInArchive = SevenZip.openInArchive(null, (IInStream)new RandomAccessFileInStream(randomAccessFile));
            }
            catch (Exception exception) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (iSevenZipInArchive != null) {
                    try {
                        iSevenZipInArchive.close();
                    }
                    catch (SevenZipException sevenZipException) {
                        sevenZipException.printStackTrace();
                    }
                }
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getImagePathList(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        RandomAccessFile randomAccessFile = null;
        ISevenZipInArchive iSevenZipInArchive = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            iSevenZipInArchive = SevenZip.openInArchive(null, (IInStream)new RandomAccessFileInStream(randomAccessFile));
            ISimpleInArchive iSimpleInArchive = iSevenZipInArchive.getSimpleInterface();
            for (ISimpleInArchiveItem iSimpleInArchiveItem : iSimpleInArchive.getArchiveItems()) {
                if (iSimpleInArchiveItem.isFolder()) continue;
                arrayList.add(iSimpleInArchiveItem.getPath());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (iSevenZipInArchive != null) {
                try {
                    iSevenZipInArchive.close();
                }
                catch (SevenZipException sevenZipException) {
                    sevenZipException.printStackTrace();
                }
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadImage(File file, ImageLoadCallback imageLoadCallback) {
        RandomAccessFile randomAccessFile = null;
        ISevenZipInArchive iSevenZipInArchive = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            iSevenZipInArchive = SevenZip.openInArchive(null, (IInStream)new RandomAccessFileInStream(randomAccessFile));
            ISimpleInArchive iSimpleInArchive = iSevenZipInArchive.getSimpleInterface();
            for (final ISimpleInArchiveItem iSimpleInArchiveItem : iSimpleInArchive.getArchiveItems()) {
                if (iSimpleInArchiveItem.isFolder()) continue;
                ImageFile imageFile = new ImageFile();
                imageFile.setPath(iSimpleInArchiveItem.getPath());
                imageFile.setCallback(new ImageLoaderReadCallback(){

                    @Override
                    public BufferedImage getImage() throws IOException {
                        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        try {
                            ExtractOperationResult extractOperationResult = iSimpleInArchiveItem.extractSlow(new ISequentialOutStream(){

                                public int write(byte[] byArray) throws SevenZipException {
                                    try {
                                        byteArrayOutputStream.write(byArray);
                                    }
                                    catch (IOException iOException) {
                                        throw new SevenZipException((Throwable)iOException);
                                    }
                                    return byArray.length;
                                }
                            });
                            if (extractOperationResult != ExtractOperationResult.OK) {
                                throw new IOException("Error extracting item: " + extractOperationResult);
                            }
                        }
                        catch (SevenZipException sevenZipException) {
                            throw new IOException(sevenZipException);
                        }
                        return ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                    }
                });
                imageLoadCallback.load(imageFile, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (iSevenZipInArchive != null) {
                try {
                    iSevenZipInArchive.close();
                }
                catch (SevenZipException sevenZipException) {
                    sevenZipException.printStackTrace();
                }
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

