/*
 * Decompiled with CFR 0.152.
 */
package jp.komono.mangaviewer.image.loader.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.komono.mangaviewer.image.ImageFile;
import jp.komono.mangaviewer.image.loader.ImageLoadCallback;
import jp.komono.mangaviewer.image.loader.ImageLoader;

public class FileImageLoader
implements ImageLoader {
    @Override
    public boolean isSupport(File file) {
        return file.isFile();
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public List<String> getImagePathList(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file.getAbsolutePath());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadImage(File file, ImageLoadCallback imageLoadCallback) {
        ImageFile imageFile = new ImageFile();
        imageFile.setPath(file.getAbsolutePath());
        BufferedInputStream bufferedInputStream = null;
        try {
            imageLoadCallback.load(imageFile, new BufferedInputStream(new FileInputStream(file)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

