/*
 * Decompiled with CFR 0.152.
 */
package jp.komono.mangaviewer.image.loader.impl;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.komono.mangaviewer.image.ImageFile;
import jp.komono.mangaviewer.image.loader.ImageLoadCallback;
import jp.komono.mangaviewer.image.loader.ImageLoader;
import jp.komono.mangaviewer.image.loader.ImageLoaderReadCallback;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

public class PdfImageLoader
implements ImageLoader {
    @Override
    public boolean isSupport(File file) {
        return file.isFile() && file.getName().toLowerCase().endsWith(".pdf");
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getImagePathList(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PDDocument pDDocument = null;
        try {
            pDDocument = PDDocument.load((File)file);
            List list = pDDocument.getDocumentCatalog().getAllPages();
            int n = list.size();
            for (int i = 1; i <= n; ++i) {
                arrayList.add(this.getPageName(i, n));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (pDDocument != null) {
                try {
                    pDDocument.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadImage(File file, ImageLoadCallback imageLoadCallback) {
        PDDocument pDDocument = null;
        try {
            pDDocument = PDDocument.load((File)file);
            List list = pDDocument.getDocumentCatalog().getAllPages();
            int n = list.size();
            for (int i = 1; i <= n; ++i) {
                final PDPage pDPage = (PDPage)list.get(i - 1);
                ImageFile imageFile = new ImageFile();
                imageFile.setPath(this.getPageName(i, n));
                imageFile.setCallback(new ImageLoaderReadCallback(){

                    @Override
                    public BufferedImage getImage() throws IOException {
                        return pDPage.convertToImage();
                    }
                });
                imageLoadCallback.load(imageFile, null);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (pDDocument != null) {
                try {
                    pDDocument.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private String getPageName(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = String.valueOf(n2).length() - String.valueOf(n).length();
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n);
        stringBuilder.append(" page");
        return stringBuilder.toString();
    }
}

