/*
 * Decompiled with CFR 0.152.
 */
package jp.komono.mangaviewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;
import jp.komono.mangaviewer.MangaViewerAboutBox;
import jp.komono.mangaviewer.MangaViewerApp;
import jp.komono.mangaviewer.MangaViewerReadDialog;
import jp.komono.mangaviewer.MangaViewerSaveTypePanel;
import jp.komono.mangaviewer.config.Config;
import jp.komono.mangaviewer.config.xml.ApplicationConfig;
import jp.komono.mangaviewer.config.xml.application.Position;
import jp.komono.mangaviewer.config.xml.application.Scale;
import jp.komono.mangaviewer.config.xml.application.Size;
import jp.komono.mangaviewer.config.xml.application.View;
import jp.komono.mangaviewer.custom.CustomSliderUI;
import jp.komono.mangaviewer.custom.ImagePanel;
import jp.komono.mangaviewer.custom.ImagePanelCallback;
import jp.komono.mangaviewer.image.ImageContainer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;

public class MangaViewerView
extends FrameView {
    private JLabel errorLabel;
    private JPanel errorPanel;
    private JPanel imagePanel;
    private JScrollPane imageScrollPane;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JFileChooser openFileChooser;
    private JMenuItem openFileMenuItem;
    private JPanel pageInfoPanel;
    private JLabel pageMaxLabel;
    private JTextField pageNowTextField;
    private JPanel pagePanel;
    private JLabel pageSeparatorLabel;
    private JSlider pageSlider;
    private JFileChooser saveFileChooser;
    private JMenuItem saveFileMenuItem;
    private ButtonGroup scaleButtonGroup;
    private JRadioButtonMenuItem scaleHeightMatchRadioButtonMenuItem;
    private JRadioButtonMenuItem scaleMatchRadioButtonMenuItem;
    private JMenu scaleMenu;
    private JRadioButtonMenuItem scaleOriginalRadioButtonMenuItem;
    private JRadioButtonMenuItem scaleWidthMatchRadioButtonMenuItem;
    private ButtonGroup sortButtonGroup;
    private JMenu sortMenu;
    private JRadioButtonMenuItem sortNoneRadioButtonMenuItem;
    private JRadioButtonMenuItem sortNumRadioButtonMenuItem;
    private JRadioButtonMenuItem sortStrRadioButtonMenuItem;
    private JMenu viewMenu;
    private ButtonGroup viewModeButtonGroup;
    private JMenu viewModeMenu;
    private JRadioButtonMenuItem viewModeOneRadioButtonMenuItem;
    private JRadioButtonMenuItem viewModeTwoDownRadioButtonMenuItem;
    private JRadioButtonMenuItem viewModeTwoLeftRadioButtonMenuItem;
    private JRadioButtonMenuItem viewModeTwoRightRadioButtonMenuItem;
    private JRadioButtonMenuItem viewModeTwoUpRadioButtonMenuItem;
    private JDialog aboutBox;
    private JDialog readBox;
    private String orgTitle;
    private boolean initFlg = false;
    private boolean repeatFlg;

    public MangaViewerView(SingleFrameApplication singleFrameApplication) {
        super((Application)singleFrameApplication);
        this.setFrame(new JFrame(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setVisible(boolean bl) {
                if (MangaViewerView.this.initFlg) {
                    super.setVisible(bl);
                }
            }
        });
        this.getFrame().setTitle(this.getResourceMap().getString("Application.title", new Object[0]));
        this.initComponents();
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame jFrame = MangaViewerApp.getApplication().getMainFrame();
            this.aboutBox = new MangaViewerAboutBox(jFrame);
            this.aboutBox.setLocationRelativeTo(jFrame);
        }
        MangaViewerApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.imageScrollPane = new JScrollPane();
        this.imageScrollPane.getVerticalScrollBar().setUnitIncrement(45);
        this.imageScrollPane.getHorizontalScrollBar().setUnitIncrement(45);
        this.imagePanel = new ImagePanel(this.getImagePanelCallback());
        this.initImageDrop();
        this.errorPanel = new JPanel();
        this.errorLabel = new JLabel();
        this.pagePanel = new JPanel();
        this.pageInfoPanel = new JPanel();
        this.pageNowTextField = new JTextField();
        this.pageMaxLabel = new JLabel();
        this.pageSeparatorLabel = new JLabel();
        this.pageSlider = new JSlider();
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        this.openFileMenuItem = new JMenuItem();
        this.saveFileMenuItem = new JMenuItem();
        JMenuItem jMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.viewModeMenu = new JMenu();
        this.viewModeOneRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.viewModeTwoLeftRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.viewModeTwoRightRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.viewModeTwoUpRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.viewModeTwoDownRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.sortMenu = new JMenu();
        this.sortNoneRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.sortStrRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.sortNumRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.scaleMenu = new JMenu();
        this.scaleOriginalRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.scaleMatchRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.scaleWidthMatchRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.scaleHeightMatchRadioButtonMenuItem = new JRadioButtonMenuItem();
        JMenu jMenu2 = new JMenu();
        JMenuItem jMenuItem2 = new JMenuItem();
        this.sortButtonGroup = new ButtonGroup();
        this.scaleButtonGroup = new ButtonGroup();
        this.viewModeButtonGroup = new ButtonGroup();
        this.openFileChooser = new JFileChooser();
        this.saveFileChooser = new JFileChooser();
        this.mainPanel.setName("mainPanel");
        this.imageScrollPane.setName("imageScrollPane");
        ResourceMap resourceMap = ((MangaViewerApp)Application.getInstance(MangaViewerApp.class)).getContext().getResourceMap(MangaViewerView.class);
        this.imagePanel.setBackground(resourceMap.getColor("imagePanel.background"));
        this.imagePanel.setDoubleBuffered(false);
        this.imagePanel.setName("imagePanel");
        this.imagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MangaViewerView.this.imagePanelMouseClicked(mouseEvent);
            }
        });
        this.errorPanel.setBackground(resourceMap.getColor("errorPanel.background"));
        this.errorPanel.setName("errorPanel");
        this.errorPanel.setVisible(false);
        this.errorLabel.setFont(resourceMap.getFont("errorLabel.font"));
        this.errorLabel.setForeground(resourceMap.getColor("errorLabel.foreground"));
        this.errorLabel.setText(resourceMap.getString("errorLabel.text", new Object[0]));
        this.errorLabel.setName("errorLabel");
        GroupLayout groupLayout = new GroupLayout(this.errorPanel);
        this.errorPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.errorLabel).addContainerGap(394, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel));
        GroupLayout groupLayout2 = new GroupLayout(this.imagePanel);
        this.imagePanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorPanel, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.errorPanel, -2, -1, -2).addContainerGap(232, Short.MAX_VALUE)));
        this.imageScrollPane.setViewportView(this.imagePanel);
        this.pagePanel.setName("pagePanel");
        this.pagePanel.setPreferredSize(new Dimension(250, 250));
        this.pagePanel.setVisible(false);
        this.pageInfoPanel.setName("pageInfoPanel");
        this.pageNowTextField.setHorizontalAlignment(4);
        this.pageNowTextField.setText(resourceMap.getString("pageNowTextField.text", new Object[0]));
        this.pageNowTextField.setName("pageNowTextField");
        this.pageNowTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                MangaViewerView.this.pageNowTextFieldKeyReleased(keyEvent);
            }
        });
        this.pageMaxLabel.setText(resourceMap.getString("pageMaxLabel.text", new Object[0]));
        this.pageMaxLabel.setName("pageMaxLabel");
        this.pageSeparatorLabel.setText(resourceMap.getString("pageSeparatorLabel.text", new Object[0]));
        this.pageSeparatorLabel.setName("pageSeparatorLabel");
        GroupLayout groupLayout3 = new GroupLayout(this.pageInfoPanel);
        this.pageInfoPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.pageNowTextField, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pageSeparatorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pageMaxLabel).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pageSeparatorLabel).addComponent(this.pageNowTextField, -2, -1, -2).addComponent(this.pageMaxLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pageSlider.setFont(resourceMap.getFont("pageSlider.font"));
        this.pageSlider.setMinimum(1);
        this.pageSlider.setMinorTickSpacing(5);
        this.pageSlider.setPaintTicks(true);
        this.pageSlider.setName("pageSlider");
        this.pageSlider.setLabelTable(this.pageSlider.createStandardLabels(10));
        this.pageSlider.setUI((SliderUI)((Object)new CustomSliderUI(this.pageSlider)));
        this.pageSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                MangaViewerView.this.pageSliderMouseReleased(mouseEvent);
            }
        });
        this.pageSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MangaViewerView.this.pageSliderStateChanged(changeEvent);
            }
        });
        this.pageSlider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                MangaViewerView.this.pageSliderKeyPressed(keyEvent);
            }
        });
        GroupLayout groupLayout4 = new GroupLayout(this.pagePanel);
        this.pagePanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addComponent(this.pageSlider, -1, 266, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pageInfoPanel, -2, -1, -2).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGap(8, 8, 8).addComponent(this.pageInfoPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.pageSlider, -2, -1, -2)).addContainerGap()));
        GroupLayout groupLayout5 = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.pagePanel, -1, 372, Short.MAX_VALUE).addContainerGap()).addComponent(this.imageScrollPane, -1, 396, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout5.createSequentialGroup().addComponent(this.imageScrollPane, -1, 234, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pagePanel, -2, 29, -2)));
        this.menuBar.setName("menuBar");
        jMenu.setMnemonic('F');
        jMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        jMenu.setName("fileMenu");
        this.openFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openFileMenuItem.setMnemonic('O');
        this.openFileMenuItem.setText(resourceMap.getString("openFileMenuItem.text", new Object[0]));
        this.openFileMenuItem.setName("openFileMenuItem");
        this.openFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.openFileMenuItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(this.openFileMenuItem);
        this.saveFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveFileMenuItem.setMnemonic('S');
        this.saveFileMenuItem.setText(resourceMap.getString("saveFileMenuItem.text", new Object[0]));
        this.saveFileMenuItem.setEnabled(false);
        this.saveFileMenuItem.setName("saveFileMenuItem");
        this.saveFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.saveFileMenuItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(this.saveFileMenuItem);
        jMenuItem.setText(resourceMap.getString("exitMenuItem.text", new Object[0]));
        jMenuItem.setName("exitMenuItem");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem);
        this.menuBar.add(jMenu);
        this.viewMenu.setMnemonic('V');
        this.viewMenu.setText(resourceMap.getString("viewMenu.text", new Object[0]));
        this.viewMenu.setName("viewMenu");
        this.viewModeMenu.setMnemonic('M');
        this.viewModeMenu.setText(resourceMap.getString("viewModeMenu.text", new Object[0]));
        this.viewModeMenu.setName("viewModeMenu");
        this.viewModeButtonGroup.add(this.viewModeOneRadioButtonMenuItem);
        this.viewModeOneRadioButtonMenuItem.setSelected(true);
        this.viewModeOneRadioButtonMenuItem.setText(resourceMap.getString("viewModeOneRadioButtonMenuItem.text", new Object[0]));
        this.viewModeOneRadioButtonMenuItem.setIcon(resourceMap.getIcon("viewModeOneRadioButtonMenuItem.icon"));
        this.viewModeOneRadioButtonMenuItem.setName("viewModeOneRadioButtonMenuItem");
        this.viewModeOneRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.viewModeOneRadioButtonMenuItemActionPerformed(actionEvent);
            }
        });
        this.viewModeMenu.add(this.viewModeOneRadioButtonMenuItem);
        this.viewModeButtonGroup.add(this.viewModeTwoLeftRadioButtonMenuItem);
        this.viewModeTwoLeftRadioButtonMenuItem.setText(resourceMap.getString("viewModeTwoLeftRadioButtonMenuItem.text", new Object[0]));
        this.viewModeTwoLeftRadioButtonMenuItem.setIcon(resourceMap.getIcon("viewModeTwoLeftRadioButtonMenuItem.icon"));
        this.viewModeTwoLeftRadioButtonMenuItem.setName("viewModeTwoLeftRadioButtonMenuItem");
        this.viewModeTwoLeftRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.viewModeTwoLeftRadioButtonMenuItemActionPerformed(actionEvent);
            }
        });
        this.viewModeMenu.add(this.viewModeTwoLeftRadioButtonMenuItem);
        this.viewModeButtonGroup.add(this.viewModeTwoRightRadioButtonMenuItem);
        this.viewModeTwoRightRadioButtonMenuItem.setText(resourceMap.getString("viewModeTwoRightRadioButtonMenuItem.text", new Object[0]));
        this.viewModeTwoRightRadioButtonMenuItem.setIcon(resourceMap.getIcon("viewModeTwoRightRadioButtonMenuItem.icon"));
        this.viewModeTwoRightRadioButtonMenuItem.setName("viewModeTwoRightRadioButtonMenuItem");
        this.viewModeTwoRightRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.viewModeTwoRightRadioButtonMenuItemActionPerformed(actionEvent);
            }
        });
        this.viewModeMenu.add(this.viewModeTwoRightRadioButtonMenuItem);
        this.viewModeButtonGroup.add(this.viewModeTwoUpRadioButtonMenuItem);
        this.viewModeTwoUpRadioButtonMenuItem.setText(resourceMap.getString("viewModeTwoUpRadioButtonMenuItem.text", new Object[0]));
        this.viewModeTwoUpRadioButtonMenuItem.setIcon(resourceMap.getIcon("viewModeTwoUpRadioButtonMenuItem.icon"));
        this.viewModeTwoUpRadioButtonMenuItem.setName("viewModeTwoUpRadioButtonMenuItem");
        this.viewModeTwoUpRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.viewModeTwoUpRadioButtonMenuItemActionPerformed(actionEvent);
            }
        });
        this.viewModeMenu.add(this.viewModeTwoUpRadioButtonMenuItem);
        this.viewModeButtonGroup.add(this.viewModeTwoDownRadioButtonMenuItem);
        this.viewModeTwoDownRadioButtonMenuItem.setText(resourceMap.getString("viewModeTwoDownRadioButtonMenuItem.text", new Object[0]));
        this.viewModeTwoDownRadioButtonMenuItem.setIcon(resourceMap.getIcon("viewModeTwoDownRadioButtonMenuItem.icon"));
        this.viewModeTwoDownRadioButtonMenuItem.setName("viewModeTwoDownRadioButtonMenuItem");
        this.viewModeTwoDownRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.viewModeTwoDownRadioButtonMenuItemActionPerformed(actionEvent);
            }
        });
        this.viewModeMenu.add(this.viewModeTwoDownRadioButtonMenuItem);
        this.viewMenu.add(this.viewModeMenu);
        this.sortMenu.setMnemonic('S');
        this.sortMenu.setText(resourceMap.getString("sortMenu.text", new Object[0]));
        this.sortMenu.setName("sortMenu");
        this.sortButtonGroup.add(this.sortNoneRadioButtonMenuItem);
        this.sortNoneRadioButtonMenuItem.setText(resourceMap.getString("sortNoneRadioButtonMenuItem.text", new Object[0]));
        this.sortNoneRadioButtonMenuItem.setName("sortNoneRadioButtonMenuItem");
        this.sortNoneRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.sortNoneRadioButtonMenuItemActionPerformed(actionEvent);
            }
        });
        this.sortMenu.add(this.sortNoneRadioButtonMenuItem);
        this.sortButtonGroup.add(this.sortStrRadioButtonMenuItem);
        this.sortStrRadioButtonMenuItem.setSelected(true);
        this.sortStrRadioButtonMenuItem.setText(resourceMap.getString("sortStrRadioButtonMenuItem.text", new Object[0]));
        this.sortStrRadioButtonMenuItem.setName("sortStrRadioButtonMenuItem");
        this.sortStrRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.sortStrRadioButtonMenuItemActionPerformed(actionEvent);
            }
        });
        this.sortMenu.add(this.sortStrRadioButtonMenuItem);
        this.sortButtonGroup.add(this.sortNumRadioButtonMenuItem);
        this.sortNumRadioButtonMenuItem.setText(resourceMap.getString("sortNumRadioButtonMenuItem.text", new Object[0]));
        this.sortNumRadioButtonMenuItem.setName("sortNumRadioButtonMenuItem");
        this.sortNumRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.sortNumRadioButtonMenuItemActionPerformed(actionEvent);
            }
        });
        this.sortMenu.add(this.sortNumRadioButtonMenuItem);
        this.viewMenu.add(this.sortMenu);
        this.scaleMenu.setMnemonic('C');
        this.scaleMenu.setText(resourceMap.getString("scaleMenu.text", new Object[0]));
        this.scaleMenu.setName("scaleMenu");
        this.scaleButtonGroup.add(this.scaleOriginalRadioButtonMenuItem);
        this.scaleOriginalRadioButtonMenuItem.setSelected(true);
        this.scaleOriginalRadioButtonMenuItem.setText(resourceMap.getString("scaleOriginalRadioButtonMenuItem.text", new Object[0]));
        this.scaleOriginalRadioButtonMenuItem.setName("scaleOriginalRadioButtonMenuItem");
        this.scaleOriginalRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.scaleOriginalRadioButtonMenuItemActionPerformed(actionEvent);
            }
        });
        this.scaleMenu.add(this.scaleOriginalRadioButtonMenuItem);
        this.scaleButtonGroup.add(this.scaleMatchRadioButtonMenuItem);
        this.scaleMatchRadioButtonMenuItem.setText(resourceMap.getString("scaleMatchRadioButtonMenuItem.text", new Object[0]));
        this.scaleMatchRadioButtonMenuItem.setName("scaleMatchRadioButtonMenuItem");
        this.scaleMatchRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.scaleMatchRadioButtonMenuItemActionPerformed(actionEvent);
            }
        });
        this.scaleMenu.add(this.scaleMatchRadioButtonMenuItem);
        this.scaleButtonGroup.add(this.scaleWidthMatchRadioButtonMenuItem);
        this.scaleWidthMatchRadioButtonMenuItem.setText(resourceMap.getString("scaleWidthMatchRadioButtonMenuItem.text", new Object[0]));
        this.scaleWidthMatchRadioButtonMenuItem.setName("scaleWidthMatchRadioButtonMenuItem");
        this.scaleWidthMatchRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.scaleWidthMatchRadioButtonMenuItemActionPerformed(actionEvent);
            }
        });
        this.scaleMenu.add(this.scaleWidthMatchRadioButtonMenuItem);
        this.scaleButtonGroup.add(this.scaleHeightMatchRadioButtonMenuItem);
        this.scaleHeightMatchRadioButtonMenuItem.setText(resourceMap.getString("scaleHeightMatchRadioButtonMenuItem.text", new Object[0]));
        this.scaleHeightMatchRadioButtonMenuItem.setName("scaleHeightMatchRadioButtonMenuItem");
        this.scaleHeightMatchRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MangaViewerView.this.scaleHeightMatchRadioButtonMenuItemActionPerformed(actionEvent);
            }
        });
        this.scaleMenu.add(this.scaleHeightMatchRadioButtonMenuItem);
        this.viewMenu.add(this.scaleMenu);
        this.menuBar.add(this.viewMenu);
        jMenu2.setMnemonic('H');
        jMenu2.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        jMenu2.setName("helpMenu");
        ApplicationActionMap applicationActionMap = ((MangaViewerApp)Application.getInstance(MangaViewerApp.class)).getContext().getActionMap(MangaViewerView.class, (Object)this);
        jMenuItem2.setAction(applicationActionMap.get("showAboutBox"));
        jMenuItem2.setName("aboutMenuItem");
        jMenu2.add(jMenuItem2);
        this.menuBar.add(jMenu2);
        this.openFileChooser.setFileSelectionMode(2);
        this.openFileChooser.setName("openFileChooser");
        this.saveFileChooser.setDialogType(1);
        this.saveFileChooser.setName("saveFileChooser");
        this.initSaveFileChooser();
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
    }

    public void init() {
        Config config = Config.getInstance();
        ApplicationConfig applicationConfig = config.getApplicationConfig();
        Position position = applicationConfig.getWindow().getPosition();
        if (position.getX() > Integer.MIN_VALUE && position.getY() > Integer.MIN_VALUE) {
            this.getFrame().setLocation(position.getX(), position.getY());
        }
        Size size = applicationConfig.getWindow().getSize();
        this.getFrame().setSize(size.getWidth(), size.getHeight());
        String string = applicationConfig.getView().getMode();
        if ("1".equals(string)) {
            this.viewModeTwoLeftRadioButtonMenuItem.setSelected(true);
        } else if ("2".equals(string)) {
            this.viewModeTwoRightRadioButtonMenuItem.setSelected(true);
        } else if ("3".equals(string)) {
            this.viewModeTwoUpRadioButtonMenuItem.setSelected(true);
        } else if ("4".equals(string)) {
            this.viewModeTwoDownRadioButtonMenuItem.setSelected(true);
        } else {
            this.viewModeOneRadioButtonMenuItem.setSelected(true);
        }
        this.viewModeChange();
        String string2 = applicationConfig.getView().getSort();
        if ("1".equals(string2)) {
            this.sortStrRadioButtonMenuItem.setSelected(true);
        } else if ("2".equals(string2)) {
            this.sortNumRadioButtonMenuItem.setSelected(true);
        } else {
            this.sortNoneRadioButtonMenuItem.setSelected(true);
        }
        this.sortChange();
        String string3 = applicationConfig.getView().getScale().getType();
        if ("1".equals(string3)) {
            this.scaleMatchRadioButtonMenuItem.setSelected(true);
        } else if ("2".equals(string3)) {
            this.scaleWidthMatchRadioButtonMenuItem.setSelected(true);
        } else if ("3".equals(string3)) {
            this.scaleHeightMatchRadioButtonMenuItem.setSelected(true);
        } else {
            this.scaleOriginalRadioButtonMenuItem.setSelected(true);
        }
        this.initFlg = true;
        this.getFrame().setVisible(true);
    }

    public void end() {
        Config config = Config.getInstance();
        ApplicationConfig applicationConfig = config.getApplicationConfig();
        JFrame jFrame = this.getFrame();
        Position position = applicationConfig.getWindow().getPosition();
        position.setX(jFrame.getX());
        position.setY(jFrame.getY());
        Size size = applicationConfig.getWindow().getSize();
        size.setWidth(jFrame.getWidth());
        size.setHeight(jFrame.getHeight());
        View view = applicationConfig.getView();
        if (this.viewModeTwoLeftRadioButtonMenuItem.isSelected()) {
            view.setMode("1");
        } else if (this.viewModeTwoRightRadioButtonMenuItem.isSelected()) {
            view.setMode("2");
        } else if (this.viewModeTwoUpRadioButtonMenuItem.isSelected()) {
            view.setMode("3");
        } else if (this.viewModeTwoDownRadioButtonMenuItem.isSelected()) {
            view.setMode("4");
        } else {
            view.setMode("0");
        }
        if (this.sortStrRadioButtonMenuItem.isSelected()) {
            view.setSort("1");
        } else if (this.sortNumRadioButtonMenuItem.isSelected()) {
            view.setSort("2");
        } else {
            view.setSort("0");
        }
        Scale scale = view.getScale();
        if (this.scaleMatchRadioButtonMenuItem.isSelected()) {
            scale.setType("1");
        } else if (this.scaleWidthMatchRadioButtonMenuItem.isSelected()) {
            scale.setType("2");
        } else if (this.scaleHeightMatchRadioButtonMenuItem.isSelected()) {
            scale.setType("3");
        } else {
            scale.setType("0");
        }
        config.saveApplicationConfig();
    }

    private void initImageDrop() {
        DropTargetAdapter dropTargetAdapter = new DropTargetAdapter(){

            @Override
            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDragEvent.acceptDrag(1);
                    return;
                }
                dropTargetDragEvent.rejectDrag();
            }

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                try {
                    if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        dropTargetDropEvent.acceptDrop(1);
                        Transferable transferable = dropTargetDropEvent.getTransferable();
                        List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        for (Object e : list) {
                            if (!(e instanceof File)) continue;
                            File file = (File)e;
                            dropTargetDropEvent.dropComplete(true);
                            MangaViewerView.this.initImage(file);
                            break;
                        }
                        dropTargetDropEvent.dropComplete(true);
                        return;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                dropTargetDropEvent.rejectDrop();
            }
        };
        DropTarget dropTarget = new DropTarget(this.imagePanel, 1, dropTargetAdapter, true);
        dropTarget.getClass();
    }

    private void initImage(File file) {
        this.showReadBox(file, false);
        ImageContainer imageContainer = ImageContainer.getInstance();
        if (imageContainer.getMaxNum() > 1) {
            this.pageSlider.setValue(imageContainer.getSelectNum());
            this.pageSlider.setMaximum(imageContainer.getMaxNum());
            this.pageMaxLabel.setText(String.valueOf(imageContainer.getMaxNum()));
            this.pagePanel.setVisible(true);
        } else {
            this.pagePanel.setVisible(false);
        }
        this.imageScrollPane.setVisible(false);
        if (this.viewModeTwoDownRadioButtonMenuItem.isSelected()) {
            this.imageScrollPane.getVerticalScrollBar().setValue(Integer.MAX_VALUE);
        } else {
            this.imageScrollPane.getVerticalScrollBar().setValue(0);
        }
        this.imageScrollPane.getHorizontalScrollBar().setValue(0);
        ((ImagePanel)this.imagePanel).forceRepaint();
        this.imageScrollPane.setVisible(true);
        if (imageContainer.getImage(false) == null) {
            this.saveFileMenuItem.setEnabled(false);
        } else {
            this.saveFileMenuItem.setEnabled(true);
        }
    }

    private void showReadBox(File file, boolean bl) {
        Object object;
        if (this.readBox == null) {
            object = MangaViewerApp.getApplication().getMainFrame();
            this.readBox = new MangaViewerReadDialog((Frame)object, true, file, bl);
            this.readBox.setLocationRelativeTo((Component)object);
        }
        this.repeatFlg = false;
        this.errorPanel.setVisible(false);
        MangaViewerApp.getApplication().show(this.readBox);
        this.readBox = null;
        object = ImageContainer.getInstance();
        if (((ImageContainer)object).getMaxNum() == 0) {
            this.viewErrorMsg("\u8aad\u8fbc\u307f\u53ef\u80fd\u306a\u753b\u50cf\u304c\u4e00\u3064\u3082\u3042\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
    }

    private ImagePanelCallback getImagePanelCallback() {
        return new ImagePanelCallback(){

            @Override
            public void error(String string) {
                MangaViewerView.this.viewErrorMsg(string);
            }

            @Override
            public void changeImage(String string) {
                if (MangaViewerView.this.orgTitle == null) {
                    MangaViewerView.this.orgTitle = MangaViewerView.this.getFrame().getTitle();
                }
                if (string == null) {
                    MangaViewerView.this.getFrame().setTitle(MangaViewerView.this.orgTitle);
                } else {
                    MangaViewerView.this.getFrame().setTitle(MangaViewerView.this.orgTitle + " - " + string);
                }
            }

            @Override
            public String getScaleType() {
                if (MangaViewerView.this.scaleMatchRadioButtonMenuItem.isSelected()) {
                    return "1";
                }
                if (MangaViewerView.this.scaleWidthMatchRadioButtonMenuItem.isSelected()) {
                    return "2";
                }
                if (MangaViewerView.this.scaleHeightMatchRadioButtonMenuItem.isSelected()) {
                    return "3";
                }
                return "0";
            }
        };
    }

    private void viewErrorMsg(String string) {
        this.viewErrorMsg(string, 0);
    }

    private void viewErrorMsg(String string, final int n) {
        this.errorLabel.setText(string);
        this.errorPanel.setVisible(true);
        if (n > 0) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        24.sleep(n);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    MangaViewerView.this.errorPanel.setVisible(false);
                }
            }.start();
        }
    }

    private void imageChange(int n) {
        ImageContainer imageContainer = ImageContainer.getInstance();
        if (n != imageContainer.getSelectNum()) {
            this.errorPanel.setVisible(false);
            this.imageScrollPane.setVisible(false);
            if (this.viewModeTwoDownRadioButtonMenuItem.isSelected()) {
                this.imageScrollPane.getVerticalScrollBar().setValue(Integer.MAX_VALUE);
            } else {
                this.imageScrollPane.getVerticalScrollBar().setValue(0);
            }
            this.imageScrollPane.getHorizontalScrollBar().setValue(0);
            imageContainer.select(n);
            ((ImagePanel)this.imagePanel).forceRepaint();
            this.imageScrollPane.setVisible(true);
            this.pageSlider.setValue(imageContainer.getSelectNum());
            if (imageContainer.getImage(false) == null) {
                this.saveFileMenuItem.setEnabled(false);
            } else {
                this.saveFileMenuItem.setEnabled(true);
            }
        }
    }

    private void sortChange() {
        ImageContainer imageContainer = ImageContainer.getInstance();
        if (this.sortStrRadioButtonMenuItem.isSelected()) {
            imageContainer.setSort("1");
        } else if (this.sortNumRadioButtonMenuItem.isSelected()) {
            imageContainer.setSort("2");
        } else {
            imageContainer.setSort("0");
        }
        if (imageContainer.getMaxNum() > 0) {
            this.showReadBox(null, true);
            ((ImagePanel)this.imagePanel).forceRepaint();
            if (imageContainer.getImage(false) == null) {
                this.saveFileMenuItem.setEnabled(false);
            } else {
                this.saveFileMenuItem.setEnabled(true);
            }
        }
    }

    private void viewModeChange() {
        ImageContainer imageContainer = ImageContainer.getInstance();
        if (this.viewModeTwoLeftRadioButtonMenuItem.isSelected()) {
            imageContainer.setViewMode("1");
        } else if (this.viewModeTwoRightRadioButtonMenuItem.isSelected()) {
            imageContainer.setViewMode("2");
        } else if (this.viewModeTwoUpRadioButtonMenuItem.isSelected()) {
            imageContainer.setViewMode("3");
        } else if (this.viewModeTwoDownRadioButtonMenuItem.isSelected()) {
            imageContainer.setViewMode("4");
        } else {
            imageContainer.setViewMode("0");
        }
        if (imageContainer.getMaxNum() > 0) {
            ((ImagePanel)this.imagePanel).forceRepaint();
            if (imageContainer.getImage(false) == null) {
                this.saveFileMenuItem.setEnabled(false);
            } else {
                this.saveFileMenuItem.setEnabled(true);
            }
        }
    }

    private void pageSliderStateChanged(ChangeEvent changeEvent) {
        this.pageNowTextField.setText(String.valueOf(this.pageSlider.getValue()));
    }

    private void imagePanelMouseClicked(MouseEvent mouseEvent) {
        ImageContainer imageContainer = ImageContainer.getInstance();
        if (imageContainer.getMaxNum() > 0) {
            if (mouseEvent.getButton() == 1) {
                int n = imageContainer.getSelectNum() + 1;
                if (!"0".equals(imageContainer.getViewMode())) {
                    ++n;
                }
                if (n <= imageContainer.getMaxNum()) {
                    this.imageChange(n);
                    this.repeatFlg = false;
                } else if (this.repeatFlg) {
                    this.repeatFlg = false;
                    this.imageChange(1);
                } else {
                    this.viewErrorMsg("\u6700\u5f8c\u306e\u30da\u30fc\u30b8\u3067\u3059\u3002", 1000);
                    this.repeatFlg = true;
                }
            } else if (mouseEvent.getButton() == 3) {
                int n = imageContainer.getSelectNum() - 1;
                if (!"0".equals(imageContainer.getViewMode())) {
                    --n;
                }
                if (n > 0) {
                    this.imageChange(n);
                } else if (this.repeatFlg) {
                    this.repeatFlg = false;
                    this.imageChange(imageContainer.getMaxNum());
                } else {
                    this.viewErrorMsg("\u6700\u521d\u306e\u30da\u30fc\u30b8\u3067\u3059\u3002", 1000);
                    this.repeatFlg = true;
                }
            }
        }
    }

    private void pageSliderMouseReleased(MouseEvent mouseEvent) {
        this.imageChange(this.pageSlider.getValue());
    }

    private void pageNowTextFieldKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            try {
                this.imageChange(Integer.valueOf(this.pageNowTextField.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void pageSliderKeyPressed(KeyEvent keyEvent) {
        this.imageChange(this.pageSlider.getValue());
    }

    private void sortNoneRadioButtonMenuItemActionPerformed(ActionEvent actionEvent) {
        this.sortChange();
    }

    private void sortStrRadioButtonMenuItemActionPerformed(ActionEvent actionEvent) {
        this.sortChange();
    }

    private void sortNumRadioButtonMenuItemActionPerformed(ActionEvent actionEvent) {
        this.sortChange();
    }

    private void scaleOriginalRadioButtonMenuItemActionPerformed(ActionEvent actionEvent) {
        ((ImagePanel)this.imagePanel).forceRepaint();
    }

    private void scaleMatchRadioButtonMenuItemActionPerformed(ActionEvent actionEvent) {
        ((ImagePanel)this.imagePanel).forceRepaint();
    }

    private void scaleWidthMatchRadioButtonMenuItemActionPerformed(ActionEvent actionEvent) {
        ((ImagePanel)this.imagePanel).forceRepaint();
    }

    private void scaleHeightMatchRadioButtonMenuItemActionPerformed(ActionEvent actionEvent) {
        ((ImagePanel)this.imagePanel).forceRepaint();
    }

    private void viewModeOneRadioButtonMenuItemActionPerformed(ActionEvent actionEvent) {
        this.viewModeChange();
    }

    private void viewModeTwoLeftRadioButtonMenuItemActionPerformed(ActionEvent actionEvent) {
        this.viewModeChange();
    }

    private void viewModeTwoRightRadioButtonMenuItemActionPerformed(ActionEvent actionEvent) {
        this.viewModeChange();
    }

    private void viewModeTwoUpRadioButtonMenuItemActionPerformed(ActionEvent actionEvent) {
        this.viewModeChange();
    }

    private void viewModeTwoDownRadioButtonMenuItemActionPerformed(ActionEvent actionEvent) {
        this.viewModeChange();
    }

    private void openFileMenuItemActionPerformed(ActionEvent actionEvent) {
        File file;
        int n = this.openFileChooser.showOpenDialog(this.getFrame());
        if (0 == n && (file = this.openFileChooser.getSelectedFile()).exists()) {
            this.initImage(file);
        }
    }

    private void initSaveFileChooser() {
        this.saveFileChooser.setAccessory(new MangaViewerSaveTypePanel());
    }

    private void saveFileMenuItemActionPerformed(ActionEvent actionEvent) {
        ImageContainer imageContainer = ImageContainer.getInstance();
        ((MangaViewerSaveTypePanel)this.saveFileChooser.getAccessory()).setImageType(imageContainer.getPath());
        this.saveFileChooser.setSelectedFile(new File(imageContainer.getPath()));
        boolean bl = true;
        File file = null;
        boolean bl2 = false;
        do {
            bl2 = false;
            int n = this.saveFileChooser.showSaveDialog(this.getFrame());
            if (0 == n) {
                file = this.saveFileChooser.getSelectedFile();
                if (!file.exists()) continue;
                if (!file.isFile()) {
                    bl = false;
                    JOptionPane.showMessageDialog(this.getFrame(), "\u4fdd\u5b58\u5148\u304c\u4e0d\u6b63\u3067\u3059\u3002", "\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58", 0);
                    continue;
                }
                int n2 = JOptionPane.showConfirmDialog(this.getFrame(), file.getAbsolutePath() + "\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002\n\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b\uff1f", "\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58", 0, 2);
                if (0 == n2) continue;
                bl2 = true;
                continue;
            }
            bl = false;
        } while (bl2);
        if (bl) {
            BufferedImage bufferedImage = imageContainer.getImage(false);
            try {
                ImageIO.write((RenderedImage)bufferedImage, ((MangaViewerSaveTypePanel)this.saveFileChooser.getAccessory()).getImageType(), file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(this.getFrame(), "\u753b\u50cf\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", "\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58", 0);
            }
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        this.getApplication().quit(actionEvent);
    }
}

