/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator.pagedrawer;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdfviewer.PageDrawer;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDInlinedImage;
import org.apache.pdfbox.util.ImageParameters;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeginInlineImage
extends OperatorProcessor {
    private static final Log log = LogFactory.getLog(BeginInlineImage.class);

    @Override
    public void process(PDFOperator operator, List<COSBase> arguments) throws IOException {
        PageDrawer drawer = (PageDrawer)this.context;
        PDPage page = drawer.getPage();
        ImageParameters params = operator.getImageParameters();
        PDInlinedImage image = new PDInlinedImage();
        image.setImageParameters(params);
        image.setImageData(operator.getImageData());
        BufferedImage awtImage = image.createImage(this.context.getColorSpaces());
        if (awtImage == null) {
            log.warn((Object)"BeginInlineImage.process(): createImage returned NULL");
            return;
        }
        int imageWidth = awtImage.getWidth();
        int imageHeight = awtImage.getHeight();
        double pageHeight = drawer.getPageSize().getHeight();
        Matrix ctm = drawer.getGraphicsState().getCurrentTransformationMatrix();
        int pageRotation = page.findRotation();
        AffineTransform ctmAT = ctm.createAffineTransform();
        ctmAT.scale(1.0f / (float)imageWidth, 1.0f / (float)imageHeight);
        Matrix rotationMatrix = new Matrix();
        rotationMatrix.setFromAffineTransform(ctmAT);
        double angle = Math.atan(ctmAT.getShearX() / ctmAT.getScaleX());
        Matrix translationMatrix = null;
        if (pageRotation == 0 || pageRotation == 180) {
            translationMatrix = Matrix.getTranslatingInstance((float)(Math.sin(angle) * (double)ctm.getXScale()), (float)(pageHeight - (double)(2.0f * ctm.getYPosition()) - Math.cos(angle) * (double)ctm.getYScale()));
        } else if (pageRotation == 90 || pageRotation == 270) {
            translationMatrix = Matrix.getTranslatingInstance((float)(Math.sin(angle) * (double)ctm.getYScale()), (float)(pageHeight - (double)(2.0f * ctm.getYPosition())));
        }
        rotationMatrix = rotationMatrix.multiply(translationMatrix);
        rotationMatrix.setValue(0, 1, -1.0f * rotationMatrix.getValue(0, 1));
        rotationMatrix.setValue(1, 0, -1.0f * rotationMatrix.getValue(1, 0));
        AffineTransform at = new AffineTransform(rotationMatrix.getValue(0, 0), rotationMatrix.getValue(0, 1), rotationMatrix.getValue(1, 0), rotationMatrix.getValue(1, 1), rotationMatrix.getValue(2, 0), rotationMatrix.getValue(2, 1));
        drawer.drawImage(awtImage, at);
    }
}

