/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.function;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;

public class PDFunctionType3
extends PDFunction {
    private COSArray functions = null;
    private COSArray encode = null;
    private COSArray bounds = null;

    public PDFunctionType3(COSBase function) {
        super(function);
    }

    public int getFunctionType() {
        return 3;
    }

    public COSArray eval(COSArray input) throws IOException {
        PDFunction function = null;
        float x = ((COSNumber)input.get(0)).floatValue();
        PDRange domain = this.getDomainForInput(1);
        x = this.clipToRange(x, domain.getMin(), domain.getMax());
        float[] boundsValues = this.getBounds().toFloatArray();
        int boundsSize = boundsValues.length;
        if (boundsSize == 0 || x < boundsValues[0]) {
            function = PDFunction.create(this.getFunctions().get(0));
            PDRange encode = this.getEncodeForParameter(0);
            x = boundsSize == 0 ? this.interpolate(x, domain.getMin(), domain.getMax(), encode.getMin(), encode.getMax()) : this.interpolate(x, domain.getMin(), boundsValues[0], encode.getMin(), encode.getMax());
        } else {
            for (int i = 0; i < boundsSize - 1; ++i) {
                if (!(x >= boundsValues[i]) || !(x < boundsValues[i + 1])) continue;
                function = PDFunction.create(this.getFunctions().get(i + 1));
                PDRange encode = this.getEncodeForParameter(i + 1);
                x = this.interpolate(x, boundsValues[i], boundsValues[i + 1], encode.getMin(), encode.getMax());
                break;
            }
            if (function == null) {
                function = PDFunction.create(this.getFunctions().get(boundsSize + 1));
                PDRange encode = this.getEncodeForParameter(boundsSize + 1);
                x = this.interpolate(x, boundsValues[boundsSize - 1], domain.getMax(), encode.getMin(), encode.getMax());
            }
        }
        COSArray functionValues = new COSArray();
        functionValues.add(new COSFloat(x));
        COSArray functionResult = function.eval(functionValues);
        return this.clipToRange(functionResult);
    }

    public COSArray getFunctions() {
        if (this.functions == null) {
            this.functions = (COSArray)this.getDictionary().getDictionaryObject(COSName.FUNCTIONS);
        }
        return this.functions;
    }

    public COSArray getBounds() {
        if (this.bounds == null) {
            this.bounds = (COSArray)this.getDictionary().getDictionaryObject(COSName.BOUNDS);
        }
        return this.bounds;
    }

    public COSArray getEncode() {
        if (this.encode == null) {
            this.encode = (COSArray)this.getDictionary().getDictionaryObject(COSName.ENCODE);
        }
        return this.encode;
    }

    private PDRange getEncodeForParameter(int n) {
        COSArray encodeValues = this.getEncode();
        return new PDRange(encodeValues, n);
    }
}

