/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sevenzipjbinding.impl;

import net.sf.sevenzipjbinding.ArchiveFormat;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.ICryptoGetTextPassword;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.ISevenZipInArchive;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.PropertyInfo;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.impl.SimpleInArchiveImpl;

public class InArchiveImpl
implements ISevenZipInArchive {
    private long sevenZipArchiveInstance;
    private long sevenZipArchiveInStreamInstance;
    private int numberOfItems = -1;
    private ArchiveFormat archiveFormat;

    public void extract(int[] nArray, boolean bl, IArchiveExtractCallback iArchiveExtractCallback) throws SevenZipException {
        this.nativeExtract(nArray, bl, iArchiveExtractCallback);
    }

    public ExtractOperationResult extractSlow(int n, ISequentialOutStream iSequentialOutStream) throws SevenZipException {
        ExtractSlowCallback extractSlowCallback = new ExtractSlowCallback(iSequentialOutStream);
        this.nativeExtract(new int[]{n}, false, extractSlowCallback);
        return extractSlowCallback.getExtractOperationResult();
    }

    public ExtractOperationResult extractSlow(int n, ISequentialOutStream iSequentialOutStream, String string) throws SevenZipException {
        ExtractSlowCryptoCallback extractSlowCryptoCallback = new ExtractSlowCryptoCallback(iSequentialOutStream, string);
        this.nativeExtract(new int[]{n}, false, extractSlowCryptoCallback);
        return extractSlowCryptoCallback.getExtractOperationResult();
    }

    private native void nativeExtract(int[] var1, boolean var2, IArchiveExtractCallback var3) throws SevenZipException;

    private native Object nativeGetArchiveProperty(int var1) throws SevenZipException;

    public Object getArchiveProperty(PropID propID) throws SevenZipException {
        return this.nativeGetArchiveProperty(propID.getPropIDIndex());
    }

    private native String nativeGetStringArchiveProperty(int var1) throws SevenZipException;

    public String getStringArchiveProperty(PropID propID) throws SevenZipException {
        return this.nativeGetStringArchiveProperty(propID.getPropIDIndex());
    }

    private native PropertyInfo nativeGetArchivePropertyInfo(int var1);

    public PropertyInfo getArchivePropertyInfo(PropID propID) throws SevenZipException {
        return this.nativeGetArchivePropertyInfo(propID.getPropIDIndex());
    }

    private native int nativeGetNumberOfArchiveProperties() throws SevenZipException;

    public int getNumberOfArchiveProperties() throws SevenZipException {
        return this.nativeGetNumberOfArchiveProperties();
    }

    private native int nativeGetNumberOfProperties() throws SevenZipException;

    public int getNumberOfProperties() throws SevenZipException {
        return this.nativeGetNumberOfProperties();
    }

    private native PropertyInfo nativeGetPropertyInfo(int var1) throws SevenZipException;

    public PropertyInfo getPropertyInfo(PropID propID) throws SevenZipException {
        return this.nativeGetPropertyInfo(propID.getPropIDIndex());
    }

    private native void nativeClose() throws SevenZipException;

    public void close() throws SevenZipException {
        this.nativeClose();
    }

    private native int nativeGetNumberOfItems() throws SevenZipException;

    public int getNumberOfItems() throws SevenZipException {
        if (this.numberOfItems == -1) {
            this.numberOfItems = this.nativeGetNumberOfItems();
        }
        return this.numberOfItems;
    }

    private native Object nativeGetProperty(int var1, int var2);

    public Object getProperty(int n, PropID propID) throws SevenZipException {
        if (n < 0 || n >= this.getNumberOfItems()) {
            throw new SevenZipException("Index out of range. Index: " + n + ", NumberOfItems: " + this.getNumberOfItems());
        }
        Object object = this.nativeGetProperty(n, propID.getPropIDIndex());
        switch (propID) {
            case SIZE: 
            case PACKED_SIZE: {
                if (object instanceof Integer) {
                    return ((Integer)object).longValue();
                }
                if (object != null || this.archiveFormat == null || this.archiveFormat != ArchiveFormat.NSIS) break;
                return 0L;
            }
            case IS_FOLDER: {
                if (object == null) {
                    return Boolean.FALSE;
                }
            }
            case ENCRYPTED: {
                if (object != null) break;
                return Boolean.FALSE;
            }
        }
        return object;
    }

    private native String nativeGetStringProperty(int var1, int var2);

    public String getStringProperty(int n, PropID propID) throws SevenZipException {
        if (n < 0 || n >= this.getNumberOfItems()) {
            throw new SevenZipException("Index out of range. Index: " + n + ", NumberOfItems: " + this.getNumberOfItems());
        }
        return this.nativeGetStringProperty(n, propID.getPropIDIndex());
    }

    public ISimpleInArchive getSimpleInterface() {
        return new SimpleInArchiveImpl(this);
    }

    public ArchiveFormat getArchiveFormat() {
        return this.archiveFormat;
    }

    private void setArchiveFormat(String string) {
        for (ArchiveFormat archiveFormat : ArchiveFormat.values()) {
            if (!archiveFormat.getMethodName().equalsIgnoreCase(string)) continue;
            this.archiveFormat = archiveFormat;
            return;
        }
    }

    private static final class ExtractSlowCryptoCallback
    extends ExtractSlowCallback
    implements ICryptoGetTextPassword {
        private String password;

        public ExtractSlowCryptoCallback(ISequentialOutStream iSequentialOutStream, String string) {
            super(iSequentialOutStream);
            this.password = string;
        }

        public String cryptoGetTextPassword() throws SevenZipException {
            return this.password;
        }
    }

    private static class ExtractSlowCallback
    implements IArchiveExtractCallback {
        ISequentialOutStream sequentialOutStreamParam;
        private ExtractOperationResult extractOperationResult;

        ExtractSlowCallback(ISequentialOutStream iSequentialOutStream) {
            this.sequentialOutStreamParam = iSequentialOutStream;
        }

        public void setTotal(long l) {
        }

        public void setCompleted(long l) {
        }

        public void setOperationResult(ExtractOperationResult extractOperationResult) {
            this.extractOperationResult = extractOperationResult;
        }

        public void prepareOperation(ExtractAskMode extractAskMode) {
        }

        public ISequentialOutStream getStream(int n, ExtractAskMode extractAskMode) {
            return extractAskMode.equals((Object)ExtractAskMode.EXTRACT) ? this.sequentialOutStreamParam : null;
        }

        ExtractOperationResult getExtractOperationResult() {
            return this.extractOperationResult;
        }
    }
}

