/*
 * Decompiled with CFR 0.152.
 */
package jp.komono.mangaviewer.image.loader.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.komono.mangaviewer.image.ImageFile;
import jp.komono.mangaviewer.image.loader.ImageLoadCallback;
import jp.komono.mangaviewer.image.loader.ImageLoader;

public class DirectoryImageLoader
implements ImageLoader {
    @Override
    public boolean isSupport(File file) {
        return file.isDirectory();
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public List<String> getImagePathList(File file) {
        File[] fileArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.isFile()) continue;
            arrayList.add(file2.getAbsolutePath());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadImage(File file, ImageLoadCallback imageLoadCallback) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.isFile()) continue;
            ImageFile imageFile = new ImageFile();
            imageFile.setPath(file2.getAbsolutePath());
            BufferedInputStream bufferedInputStream = null;
            try {
                imageLoadCallback.load(imageFile, new BufferedInputStream(new FileInputStream(file2)));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }
}

