/*
 * Decompiled with CFR 0.152.
 */
package jp.komono.mangaviewer.image.loader;

import java.io.File;
import jp.komono.mangaviewer.image.loader.ImageLoader;
import jp.komono.mangaviewer.image.loader.impl.DirectoryImageLoader;
import jp.komono.mangaviewer.image.loader.impl.FileImageLoader;
import jp.komono.mangaviewer.image.loader.impl.PdfImageLoader;
import jp.komono.mangaviewer.image.loader.impl.SevenZipImageLoader;

public class ImageLoaderFactory {
    private static ImageLoader[] loaders = new ImageLoader[]{new DirectoryImageLoader(), new PdfImageLoader(), new SevenZipImageLoader()};
    private static FileImageLoader fileImageLoader = new FileImageLoader();

    private ImageLoaderFactory() {
    }

    public static ImageLoader getInstance(File file) {
        for (ImageLoader imageLoader : loaders) {
            if (!imageLoader.isSupport(file)) continue;
            return imageLoader;
        }
        return fileImageLoader;
    }
}

