/*
 * Decompiled with CFR 0.152.
 */
package jp.komono.mangaviewer.image;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import jp.komono.mangaviewer.config.Config;
import jp.komono.mangaviewer.config.xml.BookConfig;
import jp.komono.mangaviewer.image.ImageFile;
import jp.komono.mangaviewer.image.loader.ImageLoadCallback;
import jp.komono.mangaviewer.image.loader.ImageLoader;
import jp.komono.mangaviewer.image.loader.ImageLoaderFactory;
import jp.komono.mangaviewer.image.sort.FileNameNumberComparator;

public class ImageContainer {
    private static ImageContainer instance;
    private int maxNum;
    private int selectNum;
    private List<String> imageList;
    private BufferedImage image;
    private File targetFile;
    private int imageNum;
    private Thread cacheThread;
    private boolean cacheThreadStop;
    private Map<Integer, ImageFile> cacheImageMap;
    private ImageLoader loader;
    private String sort;
    private String nowSort;
    private String viewMode;

    private ImageContainer() {
    }

    public void init(final File file) {
        if (this.maxNum > 0) {
            this.saveBookConfig();
        }
        this.targetFile = file;
        if (this.cacheThread != null) {
            this.cacheThreadStop = true;
            try {
                this.cacheThread.join();
                this.cacheImageMap.clear();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.imageList != null) {
            this.imageList.clear();
        }
        this.imageList = null;
        this.maxNum = 0;
        this.selectNum = 1;
        this.image = null;
        this.imageNum = 0;
        this.nowSort = null;
        this.loader = ImageLoaderFactory.getInstance(file);
        this.imageList = this.loader.getImagePathList(file);
        if (this.imageList == null || this.imageList.isEmpty()) {
            this.selectNum = 0;
            return;
        }
        this.sortChange();
        this.maxNum = this.imageList.size();
        Config config = Config.getInstance();
        BookConfig bookConfig = config.getBookConfig(file);
        this.selectNum = bookConfig.getPage();
        this.cacheImageMap = new HashMap<Integer, ImageFile>();
        this.cacheThreadStop = false;
        this.cacheThread = new Thread(){

            @Override
            public void run() {
                while (!ImageContainer.this.cacheThreadStop) {
                    try {
                        int n = ImageContainer.this.selectNum;
                        Set set = ImageContainer.this.cacheImageMap.keySet();
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        for (Integer n2 : set) {
                            if (n - 5 <= n2 && n + 5 >= n2) continue;
                            arrayList.add(n2);
                        }
                        for (Integer n2 : arrayList) {
                            ImageContainer.this.cacheImageMap.remove(n2);
                        }
                        final HashMap hashMap = new HashMap();
                        for (int i = n - 5; i <= n + 5 && i <= ImageContainer.this.maxNum; ++i) {
                            if (0 >= i || ImageContainer.this.cacheImageMap.containsKey(i)) continue;
                            String string = (String)ImageContainer.this.imageList.get(i - 1);
                            hashMap.put(i, string);
                        }
                        if (!hashMap.isEmpty()) {
                            if (!ImageContainer.this.targetFile.exists()) {
                                Set set2 = hashMap.keySet();
                                for (Integer n3 : set2) {
                                    ImageFile imageFile = new ImageFile();
                                    imageFile.setPath((String)ImageContainer.this.imageList.get(n3));
                                    ImageContainer.this.cacheImageMap.put(n3, imageFile);
                                }
                                continue;
                            }
                            ImageContainer.this.loader.loadImage(file, new ImageLoadCallback(){

                                @Override
                                public boolean load(ImageFile imageFile, InputStream inputStream) {
                                    if (ImageContainer.this.cacheThreadStop) {
                                        return false;
                                    }
                                    Set set = hashMap.keySet();
                                    Integer n = null;
                                    for (Integer n2 : set) {
                                        String string = (String)hashMap.get(n2);
                                        if (!string.equals(imageFile.getPath())) continue;
                                        try {
                                            if (imageFile.getCallback() == null) {
                                                imageFile.setImage(ImageIO.read(inputStream));
                                            } else {
                                                imageFile.setImage(imageFile.getCallback().getImage());
                                            }
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                        ImageContainer.this.cacheImageMap.put(n2, imageFile);
                                        n = n2;
                                        break;
                                    }
                                    if (n != null) {
                                        hashMap.remove(n);
                                        if (hashMap.isEmpty()) {
                                            return false;
                                        }
                                    }
                                    return true;
                                }
                            });
                        }
                        1.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        };
        this.cacheThread.start();
        this.getImage(false);
    }

    public BufferedImage getImage(boolean bl) {
        if (!bl && !this.isChange()) {
            return this.image;
        }
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        while (!this.cacheThreadStop && this.cacheThread.isAlive()) {
            ImageFile imageFile = this.cacheImageMap.get(this.selectNum + arrayList.size());
            if (imageFile != null) {
                this.image = imageFile.getImage();
                this.imageNum = this.selectNum;
                arrayList.add(this.image);
            }
            if (!"0".equals(this.viewMode)) {
                if (arrayList.size() > 1) {
                    this.image = null;
                    BufferedImage bufferedImage = (BufferedImage)arrayList.get(0);
                    BufferedImage bufferedImage2 = (BufferedImage)arrayList.get(1);
                    if (bufferedImage == null && bufferedImage2 == null) {
                        return this.image;
                    }
                    if (bufferedImage == null) {
                        this.image = bufferedImage2;
                        return this.image;
                    }
                    if (bufferedImage2 == null) {
                        this.image = bufferedImage;
                        return this.image;
                    }
                    int n = bufferedImage.getWidth();
                    int n2 = bufferedImage.getHeight();
                    if ("1".equals(this.viewMode) || "2".equals(this.viewMode)) {
                        n += bufferedImage2.getWidth();
                        if (n2 < bufferedImage2.getHeight()) {
                            n2 = bufferedImage2.getHeight();
                        }
                    } else {
                        if (n < bufferedImage2.getWidth()) {
                            n = bufferedImage2.getWidth();
                        }
                        n2 += bufferedImage2.getHeight();
                    }
                    this.image = new BufferedImage(n, n2, 2);
                    Graphics graphics = this.image.getGraphics();
                    if ("1".equals(this.viewMode)) {
                        graphics.drawImage(bufferedImage, 0, 0, null);
                        graphics.drawImage(bufferedImage2, bufferedImage.getWidth(), 0, null);
                    } else if ("2".equals(this.viewMode)) {
                        graphics.drawImage(bufferedImage2, 0, 0, null);
                        graphics.drawImage(bufferedImage, bufferedImage2.getWidth(), 0, null);
                    } else if ("4".equals(this.viewMode)) {
                        graphics.drawImage(bufferedImage2, 0, 0, null);
                        graphics.drawImage(bufferedImage, 0, bufferedImage2.getHeight(), null);
                    } else if ("3".equals(this.viewMode)) {
                        graphics.drawImage(bufferedImage, 0, 0, null);
                        graphics.drawImage(bufferedImage2, 0, bufferedImage.getHeight(), null);
                    }
                    return this.image;
                }
            } else if (!arrayList.isEmpty()) {
                return (BufferedImage)arrayList.get(0);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return this.image;
    }

    public void select(int n) {
        this.selectNum = n;
    }

    public int getMaxNum() {
        return this.maxNum;
    }

    public int getSelectNum() {
        return this.selectNum;
    }

    public boolean isChange() {
        return this.imageNum != this.selectNum;
    }

    public String getPath() {
        if (this.selectNum > 0) {
            return this.imageList.get(this.selectNum - 1);
        }
        return null;
    }

    private void saveBookConfig() {
        BookConfig bookConfig = new BookConfig();
        bookConfig.setPage(this.selectNum);
        Config config = Config.getInstance();
        config.saveBookConfig(bookConfig, this.targetFile);
    }

    public void dispose() {
        if (this.maxNum > 0) {
            this.saveBookConfig();
        }
        if (this.cacheThread != null) {
            this.cacheThreadStop = true;
            try {
                this.cacheThread.join();
                this.cacheImageMap.clear();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String string) {
        this.sort = string;
    }

    public String getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(String string) {
        this.viewMode = string;
    }

    public void sortChange() {
        if (this.imageList != null) {
            if (this.nowSort != null && !"0".equals(this.nowSort) && "0".equals(this.sort)) {
                int n = this.selectNum;
                this.init(this.targetFile);
                this.select(n);
            } else if ("1".equals(this.sort)) {
                Collections.sort(this.imageList, new Comparator<String>(){

                    @Override
                    public int compare(String string, String string2) {
                        return string.compareTo(string2);
                    }
                });
            } else if ("2".equals(this.sort)) {
                Collections.sort(this.imageList, new FileNameNumberComparator());
            }
            if (this.cacheImageMap != null) {
                this.cacheImageMap.clear();
            }
            this.nowSort = this.sort;
        }
    }

    public static synchronized ImageContainer getInstance() {
        if (instance == null) {
            instance = new ImageContainer();
        }
        return instance;
    }
}

