/*
 * Decompiled with CFR 0.152.
 */
package jp.komono.mangaviewer.custom;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import jp.komono.mangaviewer.custom.ImagePanelCallback;
import jp.komono.mangaviewer.image.ImageContainer;

public class ImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int height;
    private int width;
    private ImagePanelCallback callback;
    private boolean forceRepaint;
    private BufferedImage bufferedImage;

    public ImagePanel(ImagePanelCallback imagePanelCallback) {
        this.callback = imagePanelCallback;
        this.forceRepaint = false;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        ImageContainer imageContainer = ImageContainer.getInstance();
        if (imageContainer.getMaxNum() > 0) {
            boolean bl = imageContainer.isChange();
            String string = imageContainer.getPath();
            this.callback.changeImage(string);
            BufferedImage bufferedImage = imageContainer.getImage(this.forceRepaint);
            if (this.forceRepaint) {
                bl = true;
            }
            this.forceRepaint = false;
            if (bufferedImage == null) {
                this.callback.error("\u753b\u50cf\u306e\u8aad\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                return;
            }
            double d = bufferedImage.getWidth();
            double d2 = bufferedImage.getHeight();
            boolean bl2 = true;
            if (d > d2) {
                bl2 = false;
            }
            JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
            double d3 = jScrollPane.getWidth();
            double d4 = jScrollPane.getHeight() - 2;
            String string2 = this.callback.getScaleType();
            double d5 = 1.0;
            double d6 = 1.0;
            int n = (int)(d * d5);
            int n2 = (int)(d2 * d6);
            if (!"0".equals(string2)) {
                d5 = d3 / d;
                d6 = d4 / d2;
                if ("2".equals(string2)) {
                    bl2 = true;
                } else if ("3".equals(string2)) {
                    bl2 = false;
                }
                if (bl2) {
                    if (d3 > d) {
                        d5 = 1.0;
                    }
                    d6 = d5;
                } else {
                    if (d4 > d2) {
                        d6 = 1.0;
                    }
                    d5 = d6;
                }
                n = (int)(d * d5);
                n2 = (int)(d2 * d6);
                if (bl2) {
                    if (d4 <= (double)n2) {
                        d3 = jScrollPane.getWidth() - jScrollPane.getVerticalScrollBar().getWidth() - 2;
                        d5 = d3 / d;
                        if (d3 > d) {
                            d5 = 1.0;
                        }
                        d6 = d5;
                    }
                } else if (d3 <= (double)n) {
                    d4 = jScrollPane.getHeight() - jScrollPane.getHorizontalScrollBar().getHeight() - 2;
                    d6 = d4 / d2;
                    if (d4 > d2) {
                        d6 = 1.0;
                    }
                    d5 = d6;
                }
            }
            n = (int)(d * d5);
            n2 = (int)(d2 * d6);
            if (this.width != n || this.height != n2) {
                bl = true;
            }
            if (this.bufferedImage == null || bl) {
                this.bufferedImage = new BufferedImage(n, n2, bufferedImage.getType());
                Graphics2D graphics2D = (Graphics2D)this.bufferedImage.getGraphics();
                graphics2D.scale(d5, d6);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.drawImage((Image)bufferedImage, 0, 0, this);
            }
            int n3 = 0;
            int n4 = 0;
            if (d3 > (double)n) {
                if ("0".equals(string2) && d4 <= (double)n2) {
                    d3 = jScrollPane.getWidth() - jScrollPane.getVerticalScrollBar().getWidth() - 2;
                }
                n3 = (int)((d3 - (double)n) / 2.0);
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawImage((Image)this.bufferedImage, n3, n4, this);
            if (bl) {
                this.width = n;
                this.height = n2;
                this.setPreferredSize(new Dimension(n, n2));
                jScrollPane.updateUI();
                this.updateUI();
            }
        }
    }

    public void forceRepaint() {
        this.forceRepaint = true;
        this.repaint();
    }
}

