/*
 * Decompiled with CFR 0.152.
 */
package jp.komono.mangaviewer.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import jp.komono.mangaviewer.config.xml.ApplicationConfig;
import jp.komono.mangaviewer.config.xml.BookConfig;
import jp.komono.mangaviewer.config.xml.application.Position;
import jp.komono.mangaviewer.config.xml.application.Scale;
import jp.komono.mangaviewer.config.xml.application.Size;
import jp.komono.mangaviewer.config.xml.application.View;
import jp.komono.mangaviewer.config.xml.application.Window;
import jp.komono.mangaviewer.util.HashUtil;
import jp.komono.mangaviewer.util.IOUtil;

public class Config {
    private static Config instance;
    private String applicationPath;
    private ApplicationConfig applicationConfig;
    private String bookConfigPath;

    private Config() {
        this.init();
    }

    private void init() {
        this.applicationPath = System.getProperty("java.application.path", new File(new File(".").getAbsolutePath()).getParentFile().getAbsolutePath());
        this.bookConfigPath = new File(this.applicationPath, "books").getAbsolutePath();
        File file = new File(this.applicationPath, "config.xml");
        if (file.exists()) {
            this.applicationConfig = this.readConfig(ApplicationConfig.class, file);
        }
        this.checkAppConfig();
    }

    private void checkAppConfig() {
        Scale scale;
        Size size;
        Position position;
        Window window;
        if (this.applicationConfig == null) {
            this.applicationConfig = new ApplicationConfig();
        }
        if ((window = this.applicationConfig.getWindow()) == null) {
            window = new Window();
        }
        if ((position = window.getPosition()) == null) {
            position = new Position();
            position.setX(Integer.MIN_VALUE);
            position.setY(Integer.MIN_VALUE);
            window.setPosition(position);
        }
        if ((size = window.getSize()) == null) {
            size = new Size();
            size.setWidth(500);
            size.setHeight(400);
            window.setSize(size);
        }
        this.applicationConfig.setWindow(window);
        View view = this.applicationConfig.getView();
        if (view == null) {
            view = new View();
            view.setMode("0");
            view.setSort("1");
        }
        if ((scale = view.getScale()) == null) {
            scale = new Scale();
            scale.setMode("0");
            scale.setType("1");
            view.setScale(scale);
        }
        this.applicationConfig.setView(view);
    }

    private void checkBookConfig(BookConfig bookConfig) {
        if (bookConfig.getPage() < 1) {
            bookConfig.setPage(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private <T> T readConfig(Class<T> clazz, File file) {
        block7: {
            Object object;
            BufferedReader bufferedReader = null;
            try {
                JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                object = unmarshaller.unmarshal((Reader)bufferedReader);
                IOUtil.close(bufferedReader);
            }
            catch (JAXBException jAXBException) {
                jAXBException.printStackTrace();
                break block7;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtil.close(bufferedReader);
            }
            return (T)object;
        }
        return null;
    }

    private <T> void saveConfig(T t, File file) {
        BufferedWriter bufferedWriter = null;
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{t.getClass()});
            Marshaller marshaller = jAXBContext.createMarshaller();
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            marshaller.marshal(t, (Writer)bufferedWriter);
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public void saveApplicationConfig() {
        File file = new File(this.applicationPath, "config.xml");
        this.saveConfig(this.applicationConfig, file);
    }

    public void saveBookConfig(BookConfig bookConfig, File file) {
        new File(this.bookConfigPath).mkdirs();
        File file2 = this.getBookConfigFile(file);
        this.saveConfig(bookConfig, file2);
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public BookConfig getBookConfig(File file) {
        File file2 = this.getBookConfigFile(file);
        BookConfig bookConfig = null;
        if (file2.exists()) {
            bookConfig = this.readConfig(BookConfig.class, file2);
        }
        if (bookConfig == null) {
            bookConfig = new BookConfig();
        }
        this.checkBookConfig(bookConfig);
        return bookConfig;
    }

    private File getBookConfigFile(File file) {
        String string = HashUtil.getHash(file.getName() + file.length(), "MD5");
        File file2 = new File(this.bookConfigPath, string);
        return file2;
    }

    public static synchronized Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }
}

