/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.SMModel;
import org.mozilla.universalchardet.prober.statemachine.UTF8SMModel;

public class UTF8Prober
extends CharsetProber {
    public static final float ONE_CHAR_PROB = 0.5f;
    private CodingStateMachine codingSM = new CodingStateMachine(smModel);
    private int state;
    private int numOfMBChar = 0;
    private static final SMModel smModel = new UTF8SMModel();

    public UTF8Prober() {
        this.reset();
    }

    public String getCharSetName() {
        return Constants.CHARSET_UTF_8;
    }

    public int handleData(byte[] buf, int offset, int length) {
        int maxPos = offset + length;
        int i = offset;
        while (i < maxPos) {
            int codingState = this.codingSM.nextState(buf[i]);
            if (codingState == 1) {
                this.state = 2;
                break;
            }
            if (codingState == 2) {
                this.state = 1;
                break;
            }
            if (codingState == 0 && this.codingSM.getCurrentCharLen() >= 2) {
                ++this.numOfMBChar;
            }
            ++i;
        }
        if (this.state == 0 && this.getConfidence() > 0.95f) {
            this.state = 1;
        }
        return this.state;
    }

    public int getState() {
        return this.state;
    }

    public void reset() {
        this.codingSM.reset();
        this.numOfMBChar = 0;
        this.state = 0;
    }

    public float getConfidence() {
        float unlike = 0.99f;
        if (this.numOfMBChar < 6) {
            int i = 0;
            while (i < this.numOfMBChar) {
                unlike *= 0.5f;
                ++i;
            }
            return 1.0f - unlike;
        }
        return 0.99f;
    }

    public void setOption() {
    }
}

