/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.prober.Big5Prober;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.EUCJPProber;
import org.mozilla.universalchardet.prober.EUCKRProber;
import org.mozilla.universalchardet.prober.EUCTWProber;
import org.mozilla.universalchardet.prober.GB18030Prober;
import org.mozilla.universalchardet.prober.SJISProber;
import org.mozilla.universalchardet.prober.UTF8Prober;

public class MBCSGroupProber
extends CharsetProber {
    private int state;
    private CharsetProber[] probers = new CharsetProber[7];
    private boolean[] isActive = new boolean[7];
    private int bestGuess;
    private int activeNum;

    public MBCSGroupProber() {
        this.probers[0] = new UTF8Prober();
        this.probers[1] = new SJISProber();
        this.probers[2] = new EUCJPProber();
        this.probers[3] = new GB18030Prober();
        this.probers[4] = new EUCKRProber();
        this.probers[5] = new Big5Prober();
        this.probers[6] = new EUCTWProber();
        this.reset();
    }

    public String getCharSetName() {
        if (this.bestGuess == -1) {
            this.getConfidence();
            if (this.bestGuess == -1) {
                this.bestGuess = 0;
            }
        }
        return this.probers[this.bestGuess].getCharSetName();
    }

    public float getConfidence() {
        float bestConf = 0.0f;
        if (this.state == 1) {
            return 0.99f;
        }
        if (this.state == 2) {
            return 0.01f;
        }
        int i = 0;
        while (i < this.probers.length) {
            float cf;
            if (this.isActive[i] && bestConf < (cf = this.probers[i].getConfidence())) {
                bestConf = cf;
                this.bestGuess = i;
            }
            ++i;
        }
        return bestConf;
    }

    public int getState() {
        return this.state;
    }

    public int handleData(byte[] buf, int offset, int length) {
        boolean keepNext = true;
        byte[] highbyteBuf = new byte[length];
        int highpos = 0;
        int maxPos = offset + length;
        int i = offset;
        while (i < maxPos) {
            if ((buf[i] & 0x80) != 0) {
                highbyteBuf[highpos++] = buf[i];
                keepNext = true;
            } else if (keepNext) {
                highbyteBuf[highpos++] = buf[i];
                keepNext = false;
            }
            ++i;
        }
        i = 0;
        while (i < this.probers.length) {
            if (this.isActive[i]) {
                int st = this.probers[i].handleData(highbyteBuf, 0, highpos);
                if (st == 1) {
                    this.bestGuess = i;
                    this.state = 1;
                    break;
                }
                if (st == 2) {
                    this.isActive[i] = false;
                    --this.activeNum;
                    if (this.activeNum <= 0) {
                        this.state = 2;
                        break;
                    }
                }
            }
            ++i;
        }
        return this.state;
    }

    public void reset() {
        this.activeNum = 0;
        int i = 0;
        while (i < this.probers.length) {
            this.probers[i].reset();
            this.isActive[i] = true;
            ++this.activeNum;
            ++i;
        }
        this.bestGuess = -1;
        this.state = 0;
    }

    public void setOption() {
    }
}

