/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.HZSMModel;
import org.mozilla.universalchardet.prober.statemachine.ISO2022CNSMModel;
import org.mozilla.universalchardet.prober.statemachine.ISO2022JPSMModel;
import org.mozilla.universalchardet.prober.statemachine.ISO2022KRSMModel;

public class EscCharsetProber
extends CharsetProber {
    private CodingStateMachine[] codingSM = new CodingStateMachine[4];
    private int activeSM;
    private int state;
    private String detectedCharset;
    private static final HZSMModel hzsModel = new HZSMModel();
    private static final ISO2022CNSMModel iso2022cnModel = new ISO2022CNSMModel();
    private static final ISO2022JPSMModel iso2022jpModel = new ISO2022JPSMModel();
    private static final ISO2022KRSMModel iso2022krModel = new ISO2022KRSMModel();

    public EscCharsetProber() {
        this.codingSM[0] = new CodingStateMachine(hzsModel);
        this.codingSM[1] = new CodingStateMachine(iso2022cnModel);
        this.codingSM[2] = new CodingStateMachine(iso2022jpModel);
        this.codingSM[3] = new CodingStateMachine(iso2022krModel);
        this.reset();
    }

    public String getCharSetName() {
        return this.detectedCharset;
    }

    public float getConfidence() {
        return 0.99f;
    }

    public int getState() {
        return this.state;
    }

    public int handleData(byte[] buf, int offset, int length) {
        int maxPos = offset + length;
        int i = offset;
        while (i < maxPos && this.state == 0) {
            int j = this.activeSM - 1;
            while (j >= 0) {
                int codingState = this.codingSM[j].nextState(buf[i]);
                if (codingState == 1) {
                    --this.activeSM;
                    if (this.activeSM <= 0) {
                        this.state = 2;
                        return this.state;
                    }
                    if (j != this.activeSM) {
                        CodingStateMachine t = this.codingSM[this.activeSM];
                        this.codingSM[this.activeSM] = this.codingSM[j];
                        this.codingSM[j] = t;
                    }
                } else if (codingState == 2) {
                    this.state = 1;
                    this.detectedCharset = this.codingSM[j].getCodingStateMachine();
                    return this.state;
                }
                --j;
            }
            ++i;
        }
        return this.state;
    }

    public void reset() {
        this.state = 0;
        int i = 0;
        while (i < this.codingSM.length) {
            this.codingSM[i].reset();
            ++i;
        }
        this.activeSM = this.codingSM.length;
        this.detectedCharset = null;
    }

    public void setOption() {
    }
}

