/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.util.Arrays;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.distributionanalysis.Big5DistributionAnalysis;
import org.mozilla.universalchardet.prober.statemachine.Big5SMModel;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.SMModel;

public class Big5Prober
extends CharsetProber {
    private CodingStateMachine codingSM = new CodingStateMachine(smModel);
    private int state;
    private Big5DistributionAnalysis distributionAnalyzer = new Big5DistributionAnalysis();
    private byte[] lastChar = new byte[2];
    private static final SMModel smModel = new Big5SMModel();

    public Big5Prober() {
        this.reset();
    }

    public String getCharSetName() {
        return Constants.CHARSET_BIG5;
    }

    public float getConfidence() {
        float distribCf = this.distributionAnalyzer.getConfidence();
        return distribCf;
    }

    public int getState() {
        return this.state;
    }

    public int handleData(byte[] buf, int offset, int length) {
        int maxPos = offset + length;
        int i = offset;
        while (i < maxPos) {
            int codingState = this.codingSM.nextState(buf[i]);
            if (codingState == 1) {
                this.state = 2;
                break;
            }
            if (codingState == 2) {
                this.state = 1;
                break;
            }
            if (codingState == 0) {
                int charLen = this.codingSM.getCurrentCharLen();
                if (i == offset) {
                    this.lastChar[1] = buf[offset];
                    this.distributionAnalyzer.handleOneChar(this.lastChar, 0, charLen);
                } else {
                    this.distributionAnalyzer.handleOneChar(buf, i - 1, charLen);
                }
            }
            ++i;
        }
        this.lastChar[0] = buf[maxPos - 1];
        if (this.state == 0 && this.distributionAnalyzer.gotEnoughData() && this.getConfidence() > 0.95f) {
            this.state = 1;
        }
        return this.state;
    }

    public void reset() {
        this.codingSM.reset();
        this.state = 0;
        this.distributionAnalyzer.reset();
        Arrays.fill(this.lastChar, (byte)0);
    }

    public void setOption() {
    }
}

